@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitAuthorizationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationName The name of the authorization.
 * @property circuitName The name of the express route circuit.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteCircuitAuthorizationPlainArgs(
    public val authorizationName: String,
    public val circuitName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitAuthorizationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitAuthorizationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitAuthorizationPlainArgs.builder()
            .authorizationName(authorizationName.let({ args0 -> args0 }))
            .circuitName(circuitName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteCircuitAuthorizationPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteCircuitAuthorizationPlainArgsBuilder internal constructor() {
    private var authorizationName: String? = null

    private var circuitName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the authorization.
     */
    @JvmName("sdhijmjturtdfcam")
    public suspend fun authorizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationName = mapped
    }

    /**
     * @param value The name of the express route circuit.
     */
    @JvmName("gomblwmpdbgrscfk")
    public suspend fun circuitName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.circuitName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qsmuldktvimwhorm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteCircuitAuthorizationPlainArgs =
        GetExpressRouteCircuitAuthorizationPlainArgs(
            authorizationName = authorizationName ?: throw PulumiNullFieldException("authorizationName"),
            circuitName = circuitName ?: throw PulumiNullFieldException("circuitName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
