@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRoutePortAuthorizationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationName The name of the authorization.
 * @property expressRoutePortName The name of the express route port.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRoutePortAuthorizationPlainArgs(
    public val authorizationName: String,
    public val expressRoutePortName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRoutePortAuthorizationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetExpressRoutePortAuthorizationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRoutePortAuthorizationPlainArgs.builder()
            .authorizationName(authorizationName.let({ args0 -> args0 }))
            .expressRoutePortName(expressRoutePortName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRoutePortAuthorizationPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRoutePortAuthorizationPlainArgsBuilder internal constructor() {
    private var authorizationName: String? = null

    private var expressRoutePortName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the authorization.
     */
    @JvmName("jwyfolkxyafpnqye")
    public suspend fun authorizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationName = mapped
    }

    /**
     * @param value The name of the express route port.
     */
    @JvmName("bkcvbgteengrbwvq")
    public suspend fun expressRoutePortName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressRoutePortName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pypujsrbifkoabst")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRoutePortAuthorizationPlainArgs =
        GetExpressRoutePortAuthorizationPlainArgs(
            authorizationName = authorizationName ?: throw PulumiNullFieldException("authorizationName"),
            expressRoutePortName = expressRoutePortName ?: throw
                PulumiNullFieldException("expressRoutePortName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
