@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetLocalNetworkGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localNetworkGatewayName The name of the local network gateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLocalNetworkGatewayPlainArgs(
    public val localNetworkGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetLocalNetworkGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetLocalNetworkGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetLocalNetworkGatewayPlainArgs.builder()
            .localNetworkGatewayName(localNetworkGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalNetworkGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetLocalNetworkGatewayPlainArgsBuilder internal constructor() {
    private var localNetworkGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the local network gateway.
     */
    @JvmName("nhsfavrsuqrmfxdf")
    public suspend fun localNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localNetworkGatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jljtulngsbmpnset")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLocalNetworkGatewayPlainArgs = GetLocalNetworkGatewayPlainArgs(
        localNetworkGatewayName = localNetworkGatewayName ?: throw
            PulumiNullFieldException("localNetworkGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
