@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNatRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the gateway.
 * @property natRuleName The name of the nat rule.
 * @property resourceGroupName The resource group name of the VpnGateway.
 */
public data class GetNatRulePlainArgs(
    public val gatewayName: String,
    public val natRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNatRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNatRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNatRulePlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .natRuleName(natRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatRulePlainArgs].
 */
@PulumiTagMarker
public class GetNatRulePlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var natRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the gateway.
     */
    @JvmName("lqpntkaosjubqiac")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("txfobbpvevjswsit")
    public suspend fun natRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natRuleName = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("jimhgeuajuheorgi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNatRulePlainArgs = GetNatRulePlainArgs(
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        natRuleName = natRuleName ?: throw PulumiNullFieldException("natRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
