@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkExperimentProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName The Profile identifier associated with the Tenant and Partner
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetNetworkExperimentProfilePlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkExperimentProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkExperimentProfilePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkExperimentProfilePlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkExperimentProfilePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkExperimentProfilePlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("sjdsppcchybrldvf")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ojqcobbgiorgaees")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkExperimentProfilePlainArgs = GetNetworkExperimentProfilePlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
