@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property networkProfileName The name of the public IP prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkProfilePlainArgs(
    public val expand: String? = null,
    public val networkProfileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkProfilePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkProfilePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .networkProfileName(networkProfileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkProfilePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkProfilePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var networkProfileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("qpnpyrdkcudbyahr")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the public IP prefix.
     */
    @JvmName("jafbfpwbjtwqlweh")
    public suspend fun networkProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkProfileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kklyvuegjskdclmd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkProfilePlainArgs = GetNetworkProfilePlainArgs(
        expand = expand,
        networkProfileName = networkProfileName ?: throw PulumiNullFieldException("networkProfileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
