@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkSecurityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property networkSecurityGroupName The name of the network security group.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkSecurityGroupPlainArgs(
    public val expand: String? = null,
    public val networkSecurityGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkSecurityGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkSecurityGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkSecurityGroupPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .networkSecurityGroupName(networkSecurityGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkSecurityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkSecurityGroupPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var networkSecurityGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("cijeacuraxlnukkm")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the network security group.
     */
    @JvmName("dqjhlwmxebeqqypf")
    public suspend fun networkSecurityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("keafnvmntalioiop")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkSecurityGroupPlainArgs = GetNetworkSecurityGroupPlainArgs(
        expand = expand,
        networkSecurityGroupName = networkSecurityGroupName ?: throw
            PulumiNullFieldException("networkSecurityGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
