@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateLinkServicePrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property peConnectionName The name of the private end point connection.
 * @property resourceGroupName The name of the resource group.
 * @property serviceName The name of the private link service.
 */
public data class GetPrivateLinkServicePrivateEndpointConnectionPlainArgs(
    public val expand: String? = null,
    public val peConnectionName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateLinkServicePrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetPrivateLinkServicePrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateLinkServicePrivateEndpointConnectionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .peConnectionName(peConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkServicePrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkServicePrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var peConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("swextbehvuqlgeuu")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the private end point connection.
     */
    @JvmName("avhsukhfxorexaew")
    public suspend fun peConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peConnectionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ognudjpkjarhedrv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the private link service.
     */
    @JvmName("sghtxrkdppudlhku")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetPrivateLinkServicePrivateEndpointConnectionPlainArgs =
        GetPrivateLinkServicePrivateEndpointConnectionPlainArgs(
            expand = expand,
            peConnectionName = peConnectionName ?: throw PulumiNullFieldException("peConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
