@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateResolverVirtualNetworkLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualNetworkLinkName The name of the virtual network link.
 */
public data class GetPrivateResolverVirtualNetworkLinkPlainArgs(
    public val dnsForwardingRulesetName: String,
    public val resourceGroupName: String,
    public val virtualNetworkLinkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateResolverVirtualNetworkLinkPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetPrivateResolverVirtualNetworkLinkPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateResolverVirtualNetworkLinkPlainArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkLinkName(virtualNetworkLinkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateResolverVirtualNetworkLinkPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateResolverVirtualNetworkLinkPlainArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkLinkName: String? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("ohdgawbaycfwnugq")
    public suspend fun dnsForwardingRulesetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mvainbbhsxlhpebw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("ihaaicfdjuutfluc")
    public suspend fun virtualNetworkLinkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkLinkName = mapped
    }

    internal fun build(): GetPrivateResolverVirtualNetworkLinkPlainArgs =
        GetPrivateResolverVirtualNetworkLinkPlainArgs(
            dnsForwardingRulesetName = dnsForwardingRulesetName ?: throw
                PulumiNullFieldException("dnsForwardingRulesetName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkLinkName = virtualNetworkLinkName ?: throw
                PulumiNullFieldException("virtualNetworkLinkName"),
        )
}
