@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profileName The name of the Traffic Manager profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProfilePlainArgs(
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetProfilePlainArgs =
        com.pulumi.azurenative.network.inputs.GetProfilePlainArgs.builder()
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProfilePlainArgs].
 */
@PulumiTagMarker
public class GetProfilePlainArgsBuilder internal constructor() {
    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Traffic Manager profile.
     */
    @JvmName("fliivmuxvpoholkg")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xdmilrfpyjijjbsd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProfilePlainArgs = GetProfilePlainArgs(
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
