@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetScopeConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property scopeConnectionName Name for the cross-tenant connection.
 */
public data class GetScopeConnectionPlainArgs(
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val scopeConnectionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetScopeConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetScopeConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetScopeConnectionPlainArgs.builder()
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scopeConnectionName(scopeConnectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopeConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetScopeConnectionPlainArgsBuilder internal constructor() {
    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var scopeConnectionName: String? = null

    /**
     * @param value The name of the network manager.
     */
    @JvmName("ldisitfsgjpokwsh")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uawdpordpwxcifcy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name for the cross-tenant connection.
     */
    @JvmName("cuggvynvkexpydcw")
    public suspend fun scopeConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeConnectionName = mapped
    }

    internal fun build(): GetScopeConnectionPlainArgs = GetScopeConnectionPlainArgs(
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scopeConnectionName = scopeConnectionName ?: throw PulumiNullFieldException("scopeConnectionName"),
    )
}
