@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetStaticMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkGroupName The name of the network group.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property staticMemberName The name of the static member.
 */
public data class GetStaticMemberPlainArgs(
    public val networkGroupName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val staticMemberName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetStaticMemberPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetStaticMemberPlainArgs =
        com.pulumi.azurenative.network.inputs.GetStaticMemberPlainArgs.builder()
            .networkGroupName(networkGroupName.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .staticMemberName(staticMemberName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStaticMemberPlainArgs].
 */
@PulumiTagMarker
public class GetStaticMemberPlainArgsBuilder internal constructor() {
    private var networkGroupName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var staticMemberName: String? = null

    /**
     * @param value The name of the network group.
     */
    @JvmName("faktqpvyefxawvpe")
    public suspend fun networkGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkGroupName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("tifqalhhyenpecug")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bdfkoeyluesydduw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the static member.
     */
    @JvmName("kotyejhkyalwjoge")
    public suspend fun staticMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.staticMemberName = mapped
    }

    internal fun build(): GetStaticMemberPlainArgs = GetStaticMemberPlainArgs(
        networkGroupName = networkGroupName ?: throw PulumiNullFieldException("networkGroupName"),
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        staticMemberName = staticMemberName ?: throw PulumiNullFieldException("staticMemberName"),
    )
}
