@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualHubIpConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipConfigName The name of the ipconfig.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class GetVirtualHubIpConfigurationPlainArgs(
    public val ipConfigName: String,
    public val resourceGroupName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualHubIpConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualHubIpConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualHubIpConfigurationPlainArgs.builder()
            .ipConfigName(ipConfigName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualHubIpConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualHubIpConfigurationPlainArgsBuilder internal constructor() {
    private var ipConfigName: String? = null

    private var resourceGroupName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The name of the ipconfig.
     */
    @JvmName("gfyhtqlyndcigcvk")
    public suspend fun ipConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipConfigName = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("wdrlmuimbtoubtxb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("afgidcxxxfvkqsbi")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetVirtualHubIpConfigurationPlainArgs =
        GetVirtualHubIpConfigurationPlainArgs(
            ipConfigName = ipConfigName ?: throw PulumiNullFieldException("ipConfigName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
        )
}
