@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayConnectionName The name of the virtual network gateway connection.
 */
public data class GetVirtualNetworkGatewayConnectionPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkGatewayConnectionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayConnectionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayConnectionName(
                virtualNetworkGatewayConnectionName.let({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayConnectionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayConnectionName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("owaxguiyaoupifho")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network gateway connection.
     */
    @JvmName("puskrvnbgptmnsur")
    public suspend fun virtualNetworkGatewayConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayConnectionName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayConnectionPlainArgs =
        GetVirtualNetworkGatewayConnectionPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayConnectionName = virtualNetworkGatewayConnectionName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayConnectionName"),
        )
}
