@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkLinkName The name of the virtual network link.
 */
public data class GetVirtualNetworkLinkPlainArgs(
    public val privateZoneName: String,
    public val resourceGroupName: String,
    public val virtualNetworkLinkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkLinkPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkLinkPlainArgs.builder()
            .privateZoneName(privateZoneName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkLinkName(virtualNetworkLinkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkLinkPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkLinkPlainArgsBuilder internal constructor() {
    private var privateZoneName: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkLinkName: String? = null

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("wdhsgbpldxlsrayj")
    public suspend fun privateZoneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateZoneName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("stwsdrtngwcnnkkw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("jqhomtvusgrxcemf")
    public suspend fun virtualNetworkLinkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkLinkName = mapped
    }

    internal fun build(): GetVirtualNetworkLinkPlainArgs = GetVirtualNetworkLinkPlainArgs(
        privateZoneName = privateZoneName ?: throw PulumiNullFieldException("privateZoneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkLinkName = virtualNetworkLinkName ?: throw
            PulumiNullFieldException("virtualNetworkLinkName"),
    )
}
