@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class GetVirtualNetworkPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val virtualNetworkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("sewfupdcorhkfflf")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("keqdffxtqfyqxjji")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("ejfjffabgrurkqfy")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): GetVirtualNetworkPlainArgs = GetVirtualNetworkPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
    )
}
