@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hub Item.
 * @property resourceId Resource Id.
 * @property resourceType Resource Type.
 */
public data class HubArgs(
    public val resourceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HubArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HubArgs =
        com.pulumi.azurenative.network.inputs.HubArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubArgs].
 */
@PulumiTagMarker
public class HubArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Resource Id.
     */
    @JvmName("huovogjjkpniroix")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Resource Type.
     */
    @JvmName("atidxaevryomyxve")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Resource Id.
     */
    @JvmName("evnpchxtwkqflaym")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Resource Type.
     */
    @JvmName("xhwljumyqwwotdog")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): HubArgs = HubArgs(
        resourceId = resourceId,
        resourceType = resourceType,
    )
}
