@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HubIPAddressesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP addresses associated with azure firewall.
 * @property privateIPAddress Private IP Address associated with azure firewall.
 * @property publicIPs Public IP addresses associated with azure firewall.
 */
public data class HubIPAddressesArgs(
    public val privateIPAddress: Output<String>? = null,
    public val publicIPs: Output<HubPublicIPAddressesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HubIPAddressesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HubIPAddressesArgs =
        com.pulumi.azurenative.network.inputs.HubIPAddressesArgs.builder()
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .publicIPs(publicIPs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HubIPAddressesArgs].
 */
@PulumiTagMarker
public class HubIPAddressesArgsBuilder internal constructor() {
    private var privateIPAddress: Output<String>? = null

    private var publicIPs: Output<HubPublicIPAddressesArgs>? = null

    /**
     * @param value Private IP Address associated with azure firewall.
     */
    @JvmName("gquefjfveiltymql")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value Public IP addresses associated with azure firewall.
     */
    @JvmName("ptpoqkupyfgrthyl")
    public suspend fun publicIPs(`value`: Output<HubPublicIPAddressesArgs>) {
        this.publicIPs = value
    }

    /**
     * @param value Private IP Address associated with azure firewall.
     */
    @JvmName("mlyafofgqeyxfqfi")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value Public IP addresses associated with azure firewall.
     */
    @JvmName("pueorjvcelftpssw")
    public suspend fun publicIPs(`value`: HubPublicIPAddressesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPs = mapped
    }

    /**
     * @param argument Public IP addresses associated with azure firewall.
     */
    @JvmName("qgtndodcwwxcdlkj")
    public suspend fun publicIPs(argument: suspend HubPublicIPAddressesArgsBuilder.() -> Unit) {
        val toBeMapped = HubPublicIPAddressesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPs = mapped
    }

    internal fun build(): HubIPAddressesArgs = HubIPAddressesArgs(
        privateIPAddress = privateIPAddress,
        publicIPs = publicIPs,
    )
}
