@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.InboundEndpointIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration.
 * @property privateIpAddress Private IP address of the IP configuration.
 * @property privateIpAllocationMethod Private IP address allocation method.
 * @property subnet The reference to the subnet bound to the IP configuration.
 */
public data class InboundEndpointIPConfigurationArgs(
    public val privateIpAddress: Output<String>? = null,
    public val privateIpAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val subnet: Output<SubResourceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.InboundEndpointIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.InboundEndpointIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.InboundEndpointIPConfigurationArgs.builder()
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .privateIpAllocationMethod(
                privateIpAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subnet(subnet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InboundEndpointIPConfigurationArgs].
 */
@PulumiTagMarker
public class InboundEndpointIPConfigurationArgsBuilder internal constructor() {
    private var privateIpAddress: Output<String>? = null

    private var privateIpAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Private IP address of the IP configuration.
     */
    @JvmName("mchovrwffevxdlnq")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Private IP address allocation method.
     */
    @JvmName("dayoaweoyyxwnqjs")
    public suspend
    fun privateIpAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIpAllocationMethod = value
    }

    /**
     * @param value The reference to the subnet bound to the IP configuration.
     */
    @JvmName("gvtfdvaditdicooi")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Private IP address of the IP configuration.
     */
    @JvmName("htjboqpoitoximog")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value Private IP address allocation method.
     */
    @JvmName("jiqbsbkbckfjnxkf")
    public suspend fun privateIpAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAllocationMethod = mapped
    }

    /**
     * @param value Private IP address allocation method.
     */
    @JvmName("fqwjkxslkkjobaiw")
    public fun privateIpAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpAllocationMethod = mapped
    }

    /**
     * @param value Private IP address allocation method.
     */
    @JvmName("pwswjolpwlktbevj")
    public fun privateIpAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIpAllocationMethod = mapped
    }

    /**
     * @param value The reference to the subnet bound to the IP configuration.
     */
    @JvmName("rtonqlhwxwoscquw")
    public suspend fun subnet(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet bound to the IP configuration.
     */
    @JvmName("cixdmfeipjtexjbj")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): InboundEndpointIPConfigurationArgs = InboundEndpointIPConfigurationArgs(
        privateIpAddress = privateIpAddress,
        privateIpAllocationMethod = privateIpAllocationMethod,
        subnet = subnet ?: throw PulumiNullFieldException("subnet"),
    )
}
