@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerName The name of the network manager.
 * @property regions List of regions.
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 */
public data class ListActiveConnectivityConfigurationPlainArgs(
    public val networkManagerName: String,
    public val regions: List<String>? = null,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationPlainArgs.builder()
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListActiveConnectivityConfigurationPlainArgs].
 */
@PulumiTagMarker
public class ListActiveConnectivityConfigurationPlainArgsBuilder internal constructor() {
    private var networkManagerName: String? = null

    private var regions: List<String>? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the network manager.
     */
    @JvmName("aqeoewwhsllelqjb")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value List of regions.
     */
    @JvmName("ogcqartimowvsbai")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param values List of regions.
     */
    @JvmName("vcrhfhsopkgbpmdo")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dtdrhqcsiettblya")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("gxaseaeetbrhyhai")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListActiveConnectivityConfigurationPlainArgs =
        ListActiveConnectivityConfigurationPlainArgs(
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            regions = regions,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
        )
}
