@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerName The name of the network manager.
 * @property regions List of regions.
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property top An optional query parameter which specifies the maximum number of records to be returned by the server.
 */
public data class ListActiveConnectivityConfigurationsPlainArgs(
    public val networkManagerName: String,
    public val regions: List<String>? = null,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationsPlainArgs =
        com.pulumi.azurenative.network.inputs.ListActiveConnectivityConfigurationsPlainArgs.builder()
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListActiveConnectivityConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class ListActiveConnectivityConfigurationsPlainArgsBuilder internal constructor() {
    private var networkManagerName: String? = null

    private var regions: List<String>? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    private var top: Int? = null

    /**
     * @param value The name of the network manager.
     */
    @JvmName("hnvbmveuphanooih")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value List of regions.
     */
    @JvmName("llkvgkvxaxpyghka")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param values List of regions.
     */
    @JvmName("jmdiqetxurkxesay")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rnubwcgvuymcbddf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("uhkqilfyfwsftmuq")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value An optional query parameter which specifies the maximum number of records to be returned by the server.
     */
    @JvmName("khhjktdsusdvqyea")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListActiveConnectivityConfigurationsPlainArgs =
        ListActiveConnectivityConfigurationsPlainArgs(
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            regions = regions,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
            top = top,
        )
}
