@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListActiveSecurityUserRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property networkManagerName The name of the network manager.
 * @property regions List of regions.
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 */
public data class ListActiveSecurityUserRulePlainArgs(
    public val networkManagerName: String,
    public val regions: List<String>? = null,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListActiveSecurityUserRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ListActiveSecurityUserRulePlainArgs =
        com.pulumi.azurenative.network.inputs.ListActiveSecurityUserRulePlainArgs.builder()
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListActiveSecurityUserRulePlainArgs].
 */
@PulumiTagMarker
public class ListActiveSecurityUserRulePlainArgsBuilder internal constructor() {
    private var networkManagerName: String? = null

    private var regions: List<String>? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the network manager.
     */
    @JvmName("qpnajiqoyjkrpktt")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value List of regions.
     */
    @JvmName("inpdthfmtbegdiyj")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param values List of regions.
     */
    @JvmName("scmnukjvyscqvmfo")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tcxoejtkysenviry")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("rlvrqnrqiluyiqpt")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListActiveSecurityUserRulePlainArgs = ListActiveSecurityUserRulePlainArgs(
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        regions = regions,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skipToken = skipToken,
    )
}
