@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property filters Contain all filters names and values
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property orderBy Column to sort response by
 * @property resourceGroupName The name of the resource group.
 * @property resultsPerPage The number of the results to return in each page
 * @property search Search term in all columns
 * @property skip The number of records matching the filter to skip
 */
public data class ListFirewallPolicyIdpsSignaturePlainArgs(
    public val filters: List<FilterItems>? = null,
    public val firewallPolicyName: String,
    public val orderBy: OrderBy? = null,
    public val resourceGroupName: String,
    public val resultsPerPage: Int? = null,
    public val search: String? = null,
    public val skip: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturePlainArgs =
        com.pulumi.azurenative.network.inputs.ListFirewallPolicyIdpsSignaturePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .orderBy(orderBy?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resultsPerPage(resultsPerPage?.let({ args0 -> args0 }))
            .search(search?.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFirewallPolicyIdpsSignaturePlainArgs].
 */
@PulumiTagMarker
public class ListFirewallPolicyIdpsSignaturePlainArgsBuilder internal constructor() {
    private var filters: List<FilterItems>? = null

    private var firewallPolicyName: String? = null

    private var orderBy: OrderBy? = null

    private var resourceGroupName: String? = null

    private var resultsPerPage: Int? = null

    private var search: String? = null

    private var skip: Int? = null

    /**
     * @param value Contain all filters names and values
     */
    @JvmName("pqyvrayqmbsgdeqv")
    public suspend fun filters(`value`: List<FilterItems>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Contain all filters names and values
     */
    @JvmName("jtepjepvrbswdgpq")
    public suspend fun filters(argument: List<suspend FilterItemsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { FilterItemsBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Contain all filters names and values
     */
    @JvmName("gtpojvqgeanarjdq")
    public suspend fun filters(vararg argument: suspend FilterItemsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { FilterItemsBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Contain all filters names and values
     */
    @JvmName("rviqsxebfhtaernh")
    public suspend fun filters(argument: suspend FilterItemsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterItemsBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Contain all filters names and values
     */
    @JvmName("etqnijnansjofgvp")
    public suspend fun filters(vararg values: FilterItems) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("rrhwcejaniidndfo")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Column to sort response by
     */
    @JvmName("lavelsivlahqehis")
    public suspend fun orderBy(`value`: OrderBy?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param argument Column to sort response by
     */
    @JvmName("fpkumkmooudskikn")
    public suspend fun orderBy(argument: suspend OrderByBuilder.() -> Unit) {
        val toBeMapped = OrderByBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.orderBy = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pnfjlnkkduotijtc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of the results to return in each page
     */
    @JvmName("aaxyfseykiyuysnx")
    public suspend fun resultsPerPage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resultsPerPage = mapped
    }

    /**
     * @param value Search term in all columns
     */
    @JvmName("rqmnebddchbvfpga")
    public suspend fun search(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.search = mapped
    }

    /**
     * @param value The number of records matching the filter to skip
     */
    @JvmName("bwvwhxbueyvdbdte")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    internal fun build(): ListFirewallPolicyIdpsSignaturePlainArgs =
        ListFirewallPolicyIdpsSignaturePlainArgs(
            filters = filters,
            firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
            orderBy = orderBy,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resultsPerPage = resultsPerPage,
            search = search,
            skip = skip,
        )
}
