@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveSecurityAdminRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class ListNetworkManagerEffectiveSecurityAdminRulePlainArgs(
    public val resourceGroupName: String,
    public val skipToken: String? = null,
    public val virtualNetworkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveSecurityAdminRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveSecurityAdminRulePlainArgs =
        com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveSecurityAdminRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListNetworkManagerEffectiveSecurityAdminRulePlainArgs].
 */
@PulumiTagMarker
public class ListNetworkManagerEffectiveSecurityAdminRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hysjqjdrleymdpjt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("kgtxxocucjabpkfh")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("dicpvcyvmcfsxtof")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): ListNetworkManagerEffectiveSecurityAdminRulePlainArgs =
        ListNetworkManagerEffectiveSecurityAdminRulePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
            virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        )
}
