@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 * @property exclusions The Exclusions that are applied on the policy.
 * @property managedRuleSets The managed rule sets that are associated with the policy.
 */
public data class ManagedRulesDefinitionArgs(
    public val exclusions: Output<List<OwaspCrsExclusionEntryArgs>>? = null,
    public val managedRuleSets: Output<List<ManagedRuleSetArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs =
        com.pulumi.azurenative.network.inputs.ManagedRulesDefinitionArgs.builder()
            .exclusions(
                exclusions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .managedRuleSets(
                managedRuleSets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedRulesDefinitionArgs].
 */
@PulumiTagMarker
public class ManagedRulesDefinitionArgsBuilder internal constructor() {
    private var exclusions: Output<List<OwaspCrsExclusionEntryArgs>>? = null

    private var managedRuleSets: Output<List<ManagedRuleSetArgs>>? = null

    /**
     * @param value The Exclusions that are applied on the policy.
     */
    @JvmName("bflxkmkpmnkgqrce")
    public suspend fun exclusions(`value`: Output<List<OwaspCrsExclusionEntryArgs>>) {
        this.exclusions = value
    }

    @JvmName("uybeusdknulmyghd")
    public suspend fun exclusions(vararg values: Output<OwaspCrsExclusionEntryArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values The Exclusions that are applied on the policy.
     */
    @JvmName("kdyqggykvshylauv")
    public suspend fun exclusions(values: List<Output<OwaspCrsExclusionEntryArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value The managed rule sets that are associated with the policy.
     */
    @JvmName("vvtwousubgefxsqi")
    public suspend fun managedRuleSets(`value`: Output<List<ManagedRuleSetArgs>>) {
        this.managedRuleSets = value
    }

    @JvmName("jxbcmduuccskexew")
    public suspend fun managedRuleSets(vararg values: Output<ManagedRuleSetArgs>) {
        this.managedRuleSets = Output.all(values.asList())
    }

    /**
     * @param values The managed rule sets that are associated with the policy.
     */
    @JvmName("erqiqbewfpehqrry")
    public suspend fun managedRuleSets(values: List<Output<ManagedRuleSetArgs>>) {
        this.managedRuleSets = Output.all(values)
    }

    /**
     * @param value The Exclusions that are applied on the policy.
     */
    @JvmName("vqlxlwrxkruavsyk")
    public suspend fun exclusions(`value`: List<OwaspCrsExclusionEntryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument The Exclusions that are applied on the policy.
     */
    @JvmName("mwyyebkevkdkuglk")
    public suspend
    fun exclusions(argument: List<suspend OwaspCrsExclusionEntryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OwaspCrsExclusionEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument The Exclusions that are applied on the policy.
     */
    @JvmName("tdthxpjxotbddjio")
    public suspend fun exclusions(
        vararg
        argument: suspend OwaspCrsExclusionEntryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OwaspCrsExclusionEntryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument The Exclusions that are applied on the policy.
     */
    @JvmName("cpmisemyjcteynmh")
    public suspend fun exclusions(argument: suspend OwaspCrsExclusionEntryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OwaspCrsExclusionEntryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values The Exclusions that are applied on the policy.
     */
    @JvmName("iofqguubxuwcrssv")
    public suspend fun exclusions(vararg values: OwaspCrsExclusionEntryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value The managed rule sets that are associated with the policy.
     */
    @JvmName("ylmomppxkstfmmcv")
    public suspend fun managedRuleSets(`value`: List<ManagedRuleSetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the policy.
     */
    @JvmName("qqaxcrdccwfvbvcv")
    public suspend fun managedRuleSets(argument: List<suspend ManagedRuleSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the policy.
     */
    @JvmName("pogehovriotlvpre")
    public suspend fun managedRuleSets(
        vararg
        argument: suspend ManagedRuleSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedRuleSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param argument The managed rule sets that are associated with the policy.
     */
    @JvmName("gjuoojsgobudoqmf")
    public suspend fun managedRuleSets(argument: suspend ManagedRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.managedRuleSets = mapped
    }

    /**
     * @param values The managed rule sets that are associated with the policy.
     */
    @JvmName("bjjroljtposhdksx")
    public suspend fun managedRuleSets(vararg values: ManagedRuleSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedRuleSets = mapped
    }

    internal fun build(): ManagedRulesDefinitionArgs = ManagedRulesDefinitionArgs(
        exclusions = exclusions,
        managedRuleSets = managedRuleSets ?: throw PulumiNullFieldException("managedRuleSets"),
    )
}
