@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MonitorConfigCustomHeadersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom header name and value.
 * @property name Header name.
 * @property value Header value.
 */
public data class MonitorConfigCustomHeadersArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.MonitorConfigCustomHeadersArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.MonitorConfigCustomHeadersArgs =
        com.pulumi.azurenative.network.inputs.MonitorConfigCustomHeadersArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorConfigCustomHeadersArgs].
 */
@PulumiTagMarker
public class MonitorConfigCustomHeadersArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Header name.
     */
    @JvmName("qwyapjitjcjeqhuk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Header value.
     */
    @JvmName("rxmcqxgyjkgkbudo")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Header name.
     */
    @JvmName("qkcflgclemmwukqs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Header value.
     */
    @JvmName("wsgcwlqiydyptcto")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): MonitorConfigCustomHeadersArgs = MonitorConfigCustomHeadersArgs(
        name = name,
        `value` = `value`,
    )
}
