@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NatRuleConditionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleConditionNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule condition of type nat.
 * @property description Description of the rule condition.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleConditionNetworkProtocols.
 * @property name Name of the rule condition.
 * @property ruleConditionType Rule Condition Type.
 * Expected value is 'NatRuleCondition'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class NatRuleConditionArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val ipProtocols: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>? =
        null,
    public val name: Output<String>? = null,
    public val ruleConditionType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NatRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NatRuleConditionArgs =
        com.pulumi.azurenative.network.inputs.NatRuleConditionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipProtocols(
                ipProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleConditionType(ruleConditionType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NatRuleConditionArgs].
 */
@PulumiTagMarker
public class NatRuleConditionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var ipProtocols: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>? =
        null

    private var name: Output<String>? = null

    private var ruleConditionType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("gdwpmetsueolivei")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("usjvyqrmmlkkcwna")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("vuroarkbiuhoalum")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("qbihivugfknhxxjr")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("njlstbguxrlyrqbs")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("qoyrecvhiytybfum")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("xaenrlfypebhfypo")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("meohubptvcewwlae")
    public suspend
    fun ipProtocols(`value`: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>) {
        this.ipProtocols = value
    }

    @JvmName("pamghfmwdycvkvlh")
    public suspend fun ipProtocols(
        vararg
        values: Output<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>,
    ) {
        this.ipProtocols = Output.all(values.asList())
    }

    /**
     * @param values Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("rbhdpbgaogupvqax")
    public suspend
    fun ipProtocols(values: List<Output<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>) {
        this.ipProtocols = Output.all(values)
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("toxcxqrswfuiilqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'NatRuleCondition'.
     */
    @JvmName("mhfjgwxejluplhkn")
    public suspend fun ruleConditionType(`value`: Output<String>) {
        this.ruleConditionType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("jaicdnhkeufoqcxd")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("nbbiamewnurobqli")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("kjntnnbuxfkcgqsi")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("cigrboftrguesalu")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("oxeggeolachwrhoa")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("hpkkbyscmwmemyhk")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("mimpecdivmjwxrdj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("usavnplusjrxriaj")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("imkakqvcbmylbljy")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("lppjdtopqwtmqgnl")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("eudsoxwxsgjngkfc")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("nxmjxyjhhmmxlasd")
    public suspend
    fun ipProtocols(`value`: List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param values Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("qnlrmyxwtrmpfafj")
    public suspend fun ipProtocols(
        vararg
        values: Either<String, FirewallPolicyRuleConditionNetworkProtocol>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("kshireufhyjadjkq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'NatRuleCondition'.
     */
    @JvmName("rueacrxdgdexmvfa")
    public suspend fun ruleConditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditionType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("mndsjkfcostmwctg")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("pwpklwqasiokmlcg")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("ycyneqoxkectkihr")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("ijcvchbtywjcomtr")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): NatRuleConditionArgs = NatRuleConditionArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationPorts = destinationPorts,
        ipProtocols = ipProtocols,
        name = name,
        ruleConditionType = ruleConditionType ?: throw PulumiNullFieldException("ruleConditionType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
    )
}
