@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scope of Network Manager.
 * @property managementGroups List of management groups.
 * @property subscriptions List of subscriptions.
 */
public data class NetworkManagerPropertiesNetworkManagerScopesArgs(
    public val managementGroups: Output<List<String>>? = null,
    public val subscriptions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs =
        com.pulumi.azurenative.network.inputs.NetworkManagerPropertiesNetworkManagerScopesArgs.builder()
            .managementGroups(managementGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subscriptions(subscriptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkManagerPropertiesNetworkManagerScopesArgs].
 */
@PulumiTagMarker
public class NetworkManagerPropertiesNetworkManagerScopesArgsBuilder internal constructor() {
    private var managementGroups: Output<List<String>>? = null

    private var subscriptions: Output<List<String>>? = null

    /**
     * @param value List of management groups.
     */
    @JvmName("yhwukabuqiwcngcw")
    public suspend fun managementGroups(`value`: Output<List<String>>) {
        this.managementGroups = value
    }

    @JvmName("oxthyafapmlsmjns")
    public suspend fun managementGroups(vararg values: Output<String>) {
        this.managementGroups = Output.all(values.asList())
    }

    /**
     * @param values List of management groups.
     */
    @JvmName("dalgevyfeghchmfb")
    public suspend fun managementGroups(values: List<Output<String>>) {
        this.managementGroups = Output.all(values)
    }

    /**
     * @param value List of subscriptions.
     */
    @JvmName("jwwixokxbymncmtk")
    public suspend fun subscriptions(`value`: Output<List<String>>) {
        this.subscriptions = value
    }

    @JvmName("rkmuhqnffoncmqxk")
    public suspend fun subscriptions(vararg values: Output<String>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values List of subscriptions.
     */
    @JvmName("gyygpslbndrsljly")
    public suspend fun subscriptions(values: List<Output<String>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value List of management groups.
     */
    @JvmName("qhogpjbkoejuykfe")
    public suspend fun managementGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param values List of management groups.
     */
    @JvmName("sblbueyoaehttlud")
    public suspend fun managementGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value List of subscriptions.
     */
    @JvmName("vtndmssmqkgaqfcn")
    public suspend fun subscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param values List of subscriptions.
     */
    @JvmName("grhkevrvmxbxuabp")
    public suspend fun subscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    internal fun build(): NetworkManagerPropertiesNetworkManagerScopesArgs =
        NetworkManagerPropertiesNetworkManagerScopesArgs(
            managementGroups = managementGroups,
            subscriptions = subscriptions,
        )
}
