@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NsRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An NS record.
 * @property nsdname The name server name for this NS record.
 */
public data class NsRecordArgs(
    public val nsdname: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NsRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NsRecordArgs =
        com.pulumi.azurenative.network.inputs.NsRecordArgs.builder()
            .nsdname(nsdname?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NsRecordArgs].
 */
@PulumiTagMarker
public class NsRecordArgsBuilder internal constructor() {
    private var nsdname: Output<String>? = null

    /**
     * @param value The name server name for this NS record.
     */
    @JvmName("wlqrshlltpbhgpdw")
    public suspend fun nsdname(`value`: Output<String>) {
        this.nsdname = value
    }

    /**
     * @param value The name server name for this NS record.
     */
    @JvmName("mgrtcivlcbbqrpkp")
    public suspend fun nsdname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nsdname = mapped
    }

    internal fun build(): NsRecordArgs = NsRecordArgs(
        nsdname = nsdname,
    )
}
