@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VPN client root certificate of P2SVpnServerConfiguration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property publicCertData The certificate public data.
 */
public data class P2SVpnServerConfigVpnClientRootCertificateArgs(
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicCertData: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs =
        com.pulumi.azurenative.network.inputs.P2SVpnServerConfigVpnClientRootCertificateArgs.builder()
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicCertData(publicCertData.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [P2SVpnServerConfigVpnClientRootCertificateArgs].
 */
@PulumiTagMarker
public class P2SVpnServerConfigVpnClientRootCertificateArgsBuilder internal constructor() {
    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var publicCertData: Output<String>? = null

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("woctqpptuvuctkyw")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ysodrrohlsuustlm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("wskfwnewxyqitjbp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("shumnbsjsiqfcfkx")
    public suspend fun publicCertData(`value`: Output<String>) {
        this.publicCertData = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("tottsniulivbefnw")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ptklkxvsfxatsldv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("iutkfjjnrkjxofae")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("okimfrbfvbaaarhn")
    public suspend fun publicCertData(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicCertData = mapped
    }

    internal fun build(): P2SVpnServerConfigVpnClientRootCertificateArgs =
        P2SVpnServerConfigVpnClientRootCertificateArgs(
            etag = etag,
            id = id,
            name = name,
            publicCertData = publicCertData ?: throw PulumiNullFieldException("publicCertData"),
        )
}
