@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private link service resource.
 * @property autoApproval The auto-approval list of the private link service.
 * @property enableProxyProtocol Whether the private link service is enabled for proxy protocol or not.
 * @property extendedLocation The extended location of the load balancer.
 * @property fqdns The list of Fqdn.
 * @property id Resource ID.
 * @property ipConfigurations An array of private link service IP configurations.
 * @property loadBalancerFrontendIpConfigurations An array of references to the load balancer IP configurations.
 * @property location Resource location.
 * @property tags Resource tags.
 * @property visibility The visibility list of the private link service.
 */
public data class PrivateLinkServiceArgs(
    public val autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null,
    public val enableProxyProtocol: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdns: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null,
    public val loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null,
    public val location: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServiceArgs.builder()
            .autoApproval(autoApproval?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableProxyProtocol(enableProxyProtocol?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdns(fqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadBalancerFrontendIpConfigurations(
                loadBalancerFrontendIpConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .visibility(visibility?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateLinkServiceArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceArgsBuilder internal constructor() {
    private var autoApproval: Output<PrivateLinkServicePropertiesAutoApprovalArgs>? = null

    private var enableProxyProtocol: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdns: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<PrivateLinkServiceIpConfigurationArgs>>? = null

    private var loadBalancerFrontendIpConfigurations: Output<List<FrontendIPConfigurationArgs>>? =
        null

    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var visibility: Output<PrivateLinkServicePropertiesVisibilityArgs>? = null

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("nxtpmrhbulrubmop")
    public suspend fun autoApproval(`value`: Output<PrivateLinkServicePropertiesAutoApprovalArgs>) {
        this.autoApproval = value
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("mjwrisxqpqocbevg")
    public suspend fun enableProxyProtocol(`value`: Output<Boolean>) {
        this.enableProxyProtocol = value
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("soljhbddnisrmsjh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("irxlkifwhjuwtnlf")
    public suspend fun fqdns(`value`: Output<List<String>>) {
        this.fqdns = value
    }

    @JvmName("wxrfxoadisbqultk")
    public suspend fun fqdns(vararg values: Output<String>) {
        this.fqdns = Output.all(values.asList())
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("bumjhyoxwvxcrvdn")
    public suspend fun fqdns(values: List<Output<String>>) {
        this.fqdns = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gkogvpsrvrhsaawh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("iuhcwdumxcedchfp")
    public suspend
    fun ipConfigurations(`value`: Output<List<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("alrsxaeveqnxoqpw")
    public suspend fun ipConfigurations(
        vararg
        values: Output<PrivateLinkServiceIpConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("lgrergabncvtqxyt")
    public suspend fun ipConfigurations(values: List<Output<PrivateLinkServiceIpConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("wnuxnjeakeqfkcoo")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: Output<List<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = value
    }

    @JvmName("vqsbxucmfamckywb")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: Output<FrontendIPConfigurationArgs>,
    ) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("loqafafiiswmybvk")
    public suspend
    fun loadBalancerFrontendIpConfigurations(values: List<Output<FrontendIPConfigurationArgs>>) {
        this.loadBalancerFrontendIpConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("srumewfmogggxlyq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cekhxybytawsdywn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("ylroiefosjofoeij")
    public suspend fun visibility(`value`: Output<PrivateLinkServicePropertiesVisibilityArgs>) {
        this.visibility = value
    }

    /**
     * @param value The auto-approval list of the private link service.
     */
    @JvmName("oyhcfgsntanineug")
    public suspend fun autoApproval(`value`: PrivateLinkServicePropertiesAutoApprovalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoApproval = mapped
    }

    /**
     * @param argument The auto-approval list of the private link service.
     */
    @JvmName("grhritciyepwlkwc")
    public suspend
    fun autoApproval(argument: suspend PrivateLinkServicePropertiesAutoApprovalArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesAutoApprovalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoApproval = mapped
    }

    /**
     * @param value Whether the private link service is enabled for proxy protocol or not.
     */
    @JvmName("ualdsemriqueyuso")
    public suspend fun enableProxyProtocol(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableProxyProtocol = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("ymnpfesfuicyowgr")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("xsmkmaxpniibnoeq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The list of Fqdn.
     */
    @JvmName("ilkwlfysibdpprsf")
    public suspend fun fqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param values The list of Fqdn.
     */
    @JvmName("rpvwwjpqoxdrmikf")
    public suspend fun fqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ftadkmxecemsvlvt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value An array of private link service IP configurations.
     */
    @JvmName("pvqcgjblnmpyngeg")
    public suspend fun ipConfigurations(`value`: List<PrivateLinkServiceIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("nvtxjflaqadyjpfh")
    public suspend
    fun ipConfigurations(argument: List<suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("glprhenaynnakxau")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument An array of private link service IP configurations.
     */
    @JvmName("lopsdeqripdujnkl")
    public suspend
    fun ipConfigurations(argument: suspend PrivateLinkServiceIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values An array of private link service IP configurations.
     */
    @JvmName("fsqifxhmufkpkskd")
    public suspend fun ipConfigurations(vararg values: PrivateLinkServiceIpConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value An array of references to the load balancer IP configurations.
     */
    @JvmName("xjwesrhkskwoungb")
    public suspend
    fun loadBalancerFrontendIpConfigurations(`value`: List<FrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("ldsyauawfmcbhfrd")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: List<suspend FrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("fhhrmsecddvrykcr")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param argument An array of references to the load balancer IP configurations.
     */
    @JvmName("exlrhtqddkeaudop")
    public suspend
    fun loadBalancerFrontendIpConfigurations(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param values An array of references to the load balancer IP configurations.
     */
    @JvmName("mtbnhcuekohpcefi")
    public suspend fun loadBalancerFrontendIpConfigurations(
        vararg
        values: FrontendIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIpConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ulijogqlmyvwygqg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fcnrcxdqcagxinwv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vhnhlqdaqembviit")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The visibility list of the private link service.
     */
    @JvmName("siaqgctbiysgtono")
    public suspend fun visibility(`value`: PrivateLinkServicePropertiesVisibilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param argument The visibility list of the private link service.
     */
    @JvmName("hhoidayjnsvtjfpw")
    public suspend
    fun visibility(argument: suspend PrivateLinkServicePropertiesVisibilityArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServicePropertiesVisibilityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.visibility = mapped
    }

    internal fun build(): PrivateLinkServiceArgs = PrivateLinkServiceArgs(
        autoApproval = autoApproval,
        enableProxyProtocol = enableProxyProtocol,
        extendedLocation = extendedLocation,
        fqdns = fqdns,
        id = id,
        ipConfigurations = ipConfigurations,
        loadBalancerFrontendIpConfigurations = loadBalancerFrontendIpConfigurations,
        location = location,
        tags = tags,
        visibility = visibility,
    )
}
