@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServiceIpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private link service ip configuration.
 * @property id Resource ID.
 * @property name The name of private link service ip configuration.
 * @property primary Whether the ip configuration is primary or not.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAddressVersion Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property subnet The reference to the subnet resource.
 */
public data class PrivateLinkServiceIpConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val subnet: Output<SubnetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServiceIpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateLinkServiceIpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServiceIpConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAddressVersion(
                privateIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PrivateLinkServiceIpConfigurationArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceIpConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var subnet: Output<SubnetArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("aljypeftjkfgwcji")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of private link service ip configuration.
     */
    @JvmName("gqpuditpchgjgwjn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether the ip configuration is primary or not.
     */
    @JvmName("ukaqqbvhfrnlhoyp")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("nauqmnodvmjhvfsk")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("ovpfsfsdfsbtvttb")
    public suspend fun privateIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.privateIPAddressVersion = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("ebceixkifiidxdey")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("nnifmyutrisrcamt")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xucapnreeeshslsd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of private link service ip configuration.
     */
    @JvmName("ugwlyitebptupbsp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether the ip configuration is primary or not.
     */
    @JvmName("hgpnppuyvbxlutft")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("xelrqfumtgqmhvgu")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("vqjiaulwqkahgxmb")
    public suspend fun privateIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("tdijhjkqugmbkvbf")
    public fun privateIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    @JvmName("bnsfxaslreitwftw")
    public fun privateIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAddressVersion = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("awusvsiremcrcpgd")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("jcuuynsarcuokhtt")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("vrnvibumklenmsoo")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("fhsbeityebjheqpm")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet resource.
     */
    @JvmName("wotpocrysxgcaxam")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): PrivateLinkServiceIpConfigurationArgs =
        PrivateLinkServiceIpConfigurationArgs(
            id = id,
            name = name,
            primary = primary,
            privateIPAddress = privateIPAddress,
            privateIPAddressVersion = privateIPAddressVersion,
            privateIPAllocationMethod = privateIPAllocationMethod,
            subnet = subnet,
        )
}
