@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesVisibilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The visibility list of the private link service.
 * @property subscriptions The list of subscriptions.
 */
public data class PrivateLinkServicePropertiesVisibilityArgs(
    public val subscriptions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesVisibilityArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesVisibilityArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesVisibilityArgs.builder()
            .subscriptions(subscriptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrivateLinkServicePropertiesVisibilityArgs].
 */
@PulumiTagMarker
public class PrivateLinkServicePropertiesVisibilityArgsBuilder internal constructor() {
    private var subscriptions: Output<List<String>>? = null

    /**
     * @param value The list of subscriptions.
     */
    @JvmName("qqkandqatucirlmj")
    public suspend fun subscriptions(`value`: Output<List<String>>) {
        this.subscriptions = value
    }

    @JvmName("erptxhgajoklhxpg")
    public suspend fun subscriptions(vararg values: Output<String>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values The list of subscriptions.
     */
    @JvmName("wcppifgpdrhwncrc")
    public suspend fun subscriptions(values: List<Output<String>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value The list of subscriptions.
     */
    @JvmName("ptgvrrafarargqpj")
    public suspend fun subscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param values The list of subscriptions.
     */
    @JvmName("kejfombinclhlgsm")
    public suspend fun subscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    internal fun build(): PrivateLinkServicePropertiesVisibilityArgs =
        PrivateLinkServicePropertiesVisibilityArgs(
            subscriptions = subscriptions,
        )
}
