@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RadiusServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Radius Server Settings.
 * @property radiusServerAddress The address of this radius server.
 * @property radiusServerScore The initial score assigned to this radius server.
 * @property radiusServerSecret The secret used for this radius server.
 */
public data class RadiusServerArgs(
    public val radiusServerAddress: Output<String>,
    public val radiusServerScore: Output<Double>? = null,
    public val radiusServerSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RadiusServerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RadiusServerArgs =
        com.pulumi.azurenative.network.inputs.RadiusServerArgs.builder()
            .radiusServerAddress(radiusServerAddress.applyValue({ args0 -> args0 }))
            .radiusServerScore(radiusServerScore?.applyValue({ args0 -> args0 }))
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RadiusServerArgs].
 */
@PulumiTagMarker
public class RadiusServerArgsBuilder internal constructor() {
    private var radiusServerAddress: Output<String>? = null

    private var radiusServerScore: Output<Double>? = null

    private var radiusServerSecret: Output<String>? = null

    /**
     * @param value The address of this radius server.
     */
    @JvmName("rsyukrbeiowllljy")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value The initial score assigned to this radius server.
     */
    @JvmName("ogxlevetmscsjkwq")
    public suspend fun radiusServerScore(`value`: Output<Double>) {
        this.radiusServerScore = value
    }

    /**
     * @param value The secret used for this radius server.
     */
    @JvmName("ljaetusbvbrgkxjr")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value The address of this radius server.
     */
    @JvmName("xtboydjyusptkuod")
    public suspend fun radiusServerAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value The initial score assigned to this radius server.
     */
    @JvmName("hiufpmfqrtnwvvgw")
    public suspend fun radiusServerScore(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerScore = mapped
    }

    /**
     * @param value The secret used for this radius server.
     */
    @JvmName("dpwnyoqekkuuoyaf")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    internal fun build(): RadiusServerArgs = RadiusServerArgs(
        radiusServerAddress = radiusServerAddress ?: throw PulumiNullFieldException("radiusServerAddress"),
        radiusServerScore = radiusServerScore,
        radiusServerSecret = radiusServerSecret,
    )
}
