@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RouteMapRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.NextStep
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A RouteMap Rule.
 * @property actions List of actions which will be applied on a match.
 * @property matchCriteria List of matching criterion which will be applied to traffic.
 * @property name The unique name for the rule.
 * @property nextStepIfMatched Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
 */
public data class RouteMapRuleArgs(
    public val actions: Output<List<ActionArgs>>? = null,
    public val matchCriteria: Output<List<CriterionArgs>>? = null,
    public val name: Output<String>? = null,
    public val nextStepIfMatched: Output<Either<String, NextStep>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RouteMapRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RouteMapRuleArgs =
        com.pulumi.azurenative.network.inputs.RouteMapRuleArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchCriteria(
                matchCriteria?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .nextStepIfMatched(
                nextStepIfMatched?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [RouteMapRuleArgs].
 */
@PulumiTagMarker
public class RouteMapRuleArgsBuilder internal constructor() {
    private var actions: Output<List<ActionArgs>>? = null

    private var matchCriteria: Output<List<CriterionArgs>>? = null

    private var name: Output<String>? = null

    private var nextStepIfMatched: Output<Either<String, NextStep>>? = null

    /**
     * @param value List of actions which will be applied on a match.
     */
    @JvmName("ypdartffjdljsnla")
    public suspend fun actions(`value`: Output<List<ActionArgs>>) {
        this.actions = value
    }

    @JvmName("llswxebgiftexbed")
    public suspend fun actions(vararg values: Output<ActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of actions which will be applied on a match.
     */
    @JvmName("ohrxuegmqcuqxvsn")
    public suspend fun actions(values: List<Output<ActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value List of matching criterion which will be applied to traffic.
     */
    @JvmName("cugvbppblqjmcmns")
    public suspend fun matchCriteria(`value`: Output<List<CriterionArgs>>) {
        this.matchCriteria = value
    }

    @JvmName("oxqybwsslwcsyivp")
    public suspend fun matchCriteria(vararg values: Output<CriterionArgs>) {
        this.matchCriteria = Output.all(values.asList())
    }

    /**
     * @param values List of matching criterion which will be applied to traffic.
     */
    @JvmName("vipkkwrikqqrddwf")
    public suspend fun matchCriteria(values: List<Output<CriterionArgs>>) {
        this.matchCriteria = Output.all(values)
    }

    /**
     * @param value The unique name for the rule.
     */
    @JvmName("ybtdiemdljhpijim")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
     */
    @JvmName("sobwibjbcqwdwiyo")
    public suspend fun nextStepIfMatched(`value`: Output<Either<String, NextStep>>) {
        this.nextStepIfMatched = value
    }

    /**
     * @param value List of actions which will be applied on a match.
     */
    @JvmName("uqkrfhvlglnaosuv")
    public suspend fun actions(`value`: List<ActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument List of actions which will be applied on a match.
     */
    @JvmName("xwsmfimgygsgrnfm")
    public suspend fun actions(argument: List<suspend ActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ActionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions which will be applied on a match.
     */
    @JvmName("kgephrsopfqjmqdm")
    public suspend fun actions(vararg argument: suspend ActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ActionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions which will be applied on a match.
     */
    @JvmName("exghqfkjmoeffdrj")
    public suspend fun actions(argument: suspend ActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values List of actions which will be applied on a match.
     */
    @JvmName("eabprtpbhejfvirc")
    public suspend fun actions(vararg values: ActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value List of matching criterion which will be applied to traffic.
     */
    @JvmName("iprsvwfsuqrhkiem")
    public suspend fun matchCriteria(`value`: List<CriterionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchCriteria = mapped
    }

    /**
     * @param argument List of matching criterion which will be applied to traffic.
     */
    @JvmName("ilbwjebkpoyagkpy")
    public suspend fun matchCriteria(argument: List<suspend CriterionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CriterionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.matchCriteria = mapped
    }

    /**
     * @param argument List of matching criterion which will be applied to traffic.
     */
    @JvmName("tjmihgjnpwgsmnwm")
    public suspend fun matchCriteria(vararg argument: suspend CriterionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CriterionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.matchCriteria = mapped
    }

    /**
     * @param argument List of matching criterion which will be applied to traffic.
     */
    @JvmName("muvwwwhebehyuscc")
    public suspend fun matchCriteria(argument: suspend CriterionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CriterionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.matchCriteria = mapped
    }

    /**
     * @param values List of matching criterion which will be applied to traffic.
     */
    @JvmName("ohjtpogkvlayjfnp")
    public suspend fun matchCriteria(vararg values: CriterionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchCriteria = mapped
    }

    /**
     * @param value The unique name for the rule.
     */
    @JvmName("yskekijjfvrfroua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
     */
    @JvmName("gekvmbekjbkbivii")
    public suspend fun nextStepIfMatched(`value`: Either<String, NextStep>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStepIfMatched = mapped
    }

    /**
     * @param value Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
     */
    @JvmName("wygjcrihvsrfxqej")
    public fun nextStepIfMatched(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NextStep>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextStepIfMatched = mapped
    }

    /**
     * @param value Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
     */
    @JvmName("phfacysyhaltouon")
    public fun nextStepIfMatched(`value`: NextStep) {
        val toBeMapped = Either.ofRight<String, NextStep>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextStepIfMatched = mapped
    }

    internal fun build(): RouteMapRuleArgs = RouteMapRuleArgs(
        actions = actions,
        matchCriteria = matchCriteria,
        name = name,
        nextStepIfMatched = nextStepIfMatched,
    )
}
