@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ServiceAssociationLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ServiceAssociationLink resource.
 * @property id Resource ID.
 * @property link Link to the external resource.
 * @property linkedResourceType Resource type of the linked resource.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 */
public data class ServiceAssociationLinkArgs(
    public val id: Output<String>? = null,
    public val link: Output<String>? = null,
    public val linkedResourceType: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ServiceAssociationLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ServiceAssociationLinkArgs =
        com.pulumi.azurenative.network.inputs.ServiceAssociationLinkArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .link(link?.applyValue({ args0 -> args0 }))
            .linkedResourceType(linkedResourceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceAssociationLinkArgs].
 */
@PulumiTagMarker
public class ServiceAssociationLinkArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var link: Output<String>? = null

    private var linkedResourceType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("bbqdkvcwfyceungc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Link to the external resource.
     */
    @JvmName("uqfnrctneinmvduf")
    public suspend fun link(`value`: Output<String>) {
        this.link = value
    }

    /**
     * @param value Resource type of the linked resource.
     */
    @JvmName("dpiwjeaxctodyuys")
    public suspend fun linkedResourceType(`value`: Output<String>) {
        this.linkedResourceType = value
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("rehllxulspyptmww")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ihmboqotccjbmypf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Link to the external resource.
     */
    @JvmName("xxslpcdehhjnpknh")
    public suspend fun link(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.link = mapped
    }

    /**
     * @param value Resource type of the linked resource.
     */
    @JvmName("vhexlkbbfbcmpwrt")
    public suspend fun linkedResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedResourceType = mapped
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qeboutrekgqdsbcj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ServiceAssociationLinkArgs = ServiceAssociationLinkArgs(
        id = id,
        link = link,
        linkedResourceType = linkedResourceType,
        name = name,
    )
}
