@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Service Endpoint policy definitions.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property service Service endpoint name.
 * @property serviceResources A list of service resources.
 * @property type The type of the resource.
 */
public data class ServiceEndpointPolicyDefinitionArgs(
    public val description: Output<String>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val service: Output<String>? = null,
    public val serviceResources: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyDefinitionArgs =
        com.pulumi.azurenative.network.inputs.ServiceEndpointPolicyDefinitionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .service(service?.applyValue({ args0 -> args0 }))
            .serviceResources(serviceResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEndpointPolicyDefinitionArgs].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyDefinitionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var service: Output<String>? = null

    private var serviceResources: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("uhyjdbmalvtjdgja")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("uvhmhjycfvjijcox")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cxbyuivvormyypdw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("smsjhjohhgkfksqb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Service endpoint name.
     */
    @JvmName("vfhhebditvdwgerv")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value A list of service resources.
     */
    @JvmName("cqejoksjucqolgwe")
    public suspend fun serviceResources(`value`: Output<List<String>>) {
        this.serviceResources = value
    }

    @JvmName("jsimcluaglamxqnq")
    public suspend fun serviceResources(vararg values: Output<String>) {
        this.serviceResources = Output.all(values.asList())
    }

    /**
     * @param values A list of service resources.
     */
    @JvmName("xexiabpumhodufin")
    public suspend fun serviceResources(values: List<Output<String>>) {
        this.serviceResources = Output.all(values)
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("ekvavmbllhuusxov")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("kfwhcklqeistwheo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("wcnymkgbhjgsxcet")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nnnfsbubkwfnymud")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qtjptqljgulklktg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Service endpoint name.
     */
    @JvmName("cpofxcssqxehifjy")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param value A list of service resources.
     */
    @JvmName("jepxichwjtaesfrf")
    public suspend fun serviceResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceResources = mapped
    }

    /**
     * @param values A list of service resources.
     */
    @JvmName("fduokwwmfjgnvexw")
    public suspend fun serviceResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceResources = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("dyaxenwonkkmevcd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceEndpointPolicyDefinitionArgs = ServiceEndpointPolicyDefinitionArgs(
        description = description,
        etag = etag,
        id = id,
        name = name,
        service = service,
        serviceResources = serviceResources,
        type = type,
    )
}
