@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ServiceEndpointPropertiesFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The service endpoint properties.
 * @property locations A list of locations.
 * @property provisioningState The provisioning state of the resource.
 * @property service The type of the endpoint service.
 */
public data class ServiceEndpointPropertiesFormatArgs(
    public val locations: Output<List<String>>? = null,
    public val provisioningState: Output<String>? = null,
    public val service: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ServiceEndpointPropertiesFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ServiceEndpointPropertiesFormatArgs =
        com.pulumi.azurenative.network.inputs.ServiceEndpointPropertiesFormatArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .service(service?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEndpointPropertiesFormatArgs].
 */
@PulumiTagMarker
public class ServiceEndpointPropertiesFormatArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var provisioningState: Output<String>? = null

    private var service: Output<String>? = null

    /**
     * @param value A list of locations.
     */
    @JvmName("ftxycopbomqgdrfs")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("rftjefrkwvggpuax")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values A list of locations.
     */
    @JvmName("aritllopbiniwdiu")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("yvlsmusbhtqxobey")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The type of the endpoint service.
     */
    @JvmName("qyjeojgxsewlhled")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value A list of locations.
     */
    @JvmName("edmwmatlifltcfmt")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values A list of locations.
     */
    @JvmName("dcbxcwuwkmqmlirg")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("ylirgcugtfmpnkhk")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The type of the endpoint service.
     */
    @JvmName("dngywqgyrhurtcij")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    internal fun build(): ServiceEndpointPropertiesFormatArgs = ServiceEndpointPropertiesFormatArgs(
        locations = locations,
        provisioningState = provisioningState,
        service = service,
    )
}
