@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualHubRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualHub route.
 * @property addressPrefixes List of all addressPrefixes.
 * @property nextHopIpAddress NextHop ip address.
 */
public data class VirtualHubRouteArgs(
    public val addressPrefixes: Output<List<String>>? = null,
    public val nextHopIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualHubRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualHubRouteArgs =
        com.pulumi.azurenative.network.inputs.VirtualHubRouteArgs.builder()
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHubRouteArgs].
 */
@PulumiTagMarker
public class VirtualHubRouteArgsBuilder internal constructor() {
    private var addressPrefixes: Output<List<String>>? = null

    private var nextHopIpAddress: Output<String>? = null

    /**
     * @param value List of all addressPrefixes.
     */
    @JvmName("oymfpdocdoxhhicm")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("wvpkrniyuxmfqswk")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of all addressPrefixes.
     */
    @JvmName("wqoxlvgveskdeiya")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value NextHop ip address.
     */
    @JvmName("oqkwatxsoyjpvavd")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value List of all addressPrefixes.
     */
    @JvmName("oompygvkslhjpbtw")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of all addressPrefixes.
     */
    @JvmName("nlyboyhhtwpcgxur")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value NextHop ip address.
     */
    @JvmName("xqtngffxiqlskyyn")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    internal fun build(): VirtualHubRouteArgs = VirtualHubRouteArgs(
        addressPrefixes = addressPrefixes,
        nextHopIpAddress = nextHopIpAddress,
    )
}
