@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualHubRouteV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualHubRouteTableV2 route.
 * @property destinationType The type of destinations.
 * @property destinations List of all destinations.
 * @property nextHopType The type of next hops.
 * @property nextHops NextHops ip address.
 */
public data class VirtualHubRouteV2Args(
    public val destinationType: Output<String>? = null,
    public val destinations: Output<List<String>>? = null,
    public val nextHopType: Output<String>? = null,
    public val nextHops: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualHubRouteV2Args> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualHubRouteV2Args =
        com.pulumi.azurenative.network.inputs.VirtualHubRouteV2Args.builder()
            .destinationType(destinationType?.applyValue({ args0 -> args0 }))
            .destinations(destinations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nextHopType(nextHopType?.applyValue({ args0 -> args0 }))
            .nextHops(nextHops?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VirtualHubRouteV2Args].
 */
@PulumiTagMarker
public class VirtualHubRouteV2ArgsBuilder internal constructor() {
    private var destinationType: Output<String>? = null

    private var destinations: Output<List<String>>? = null

    private var nextHopType: Output<String>? = null

    private var nextHops: Output<List<String>>? = null

    /**
     * @param value The type of destinations.
     */
    @JvmName("nbvbswbwqpyvhayu")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value List of all destinations.
     */
    @JvmName("kgyxlsutjqexttts")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("xqncwdcktmeuqfiq")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of all destinations.
     */
    @JvmName("vnreikvepntqiiqb")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value The type of next hops.
     */
    @JvmName("ykffibulwdthaebd")
    public suspend fun nextHopType(`value`: Output<String>) {
        this.nextHopType = value
    }

    /**
     * @param value NextHops ip address.
     */
    @JvmName("mlikgkgqkqrgrhdo")
    public suspend fun nextHops(`value`: Output<List<String>>) {
        this.nextHops = value
    }

    @JvmName("acfnyihupcrjrwdl")
    public suspend fun nextHops(vararg values: Output<String>) {
        this.nextHops = Output.all(values.asList())
    }

    /**
     * @param values NextHops ip address.
     */
    @JvmName("nsmjnvidtyrrixwi")
    public suspend fun nextHops(values: List<Output<String>>) {
        this.nextHops = Output.all(values)
    }

    /**
     * @param value The type of destinations.
     */
    @JvmName("sixltchmsivnneyv")
    public suspend fun destinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value List of all destinations.
     */
    @JvmName("sjhbbdvpqvlnkdsp")
    public suspend fun destinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of all destinations.
     */
    @JvmName("sxdldbluiutdkfai")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value The type of next hops.
     */
    @JvmName("xjkkcbydufxmxtxl")
    public suspend fun nextHopType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    /**
     * @param value NextHops ip address.
     */
    @JvmName("pwxiwgkjtehsumif")
    public suspend fun nextHops(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHops = mapped
    }

    /**
     * @param values NextHops ip address.
     */
    @JvmName("sjotxauskxqaeavh")
    public suspend fun nextHops(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHops = mapped
    }

    internal fun build(): VirtualHubRouteV2Args = VirtualHubRouteV2Args(
        destinationType = destinationType,
        destinations = destinations,
        nextHopType = nextHopType,
        nextHops = nextHops,
    )
}
