@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AdminState
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayType
import com.pulumi.azurenative.network.kotlin.enums.VpnGatewayGeneration
import com.pulumi.azurenative.network.kotlin.enums.VpnType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * @property activeActive ActiveActive flag.
 * @property adminState Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
 * @property allowRemoteVnetTraffic Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
 * @property allowVirtualWanTraffic Configures this gateway to accept traffic from remote Virtual WAN networks.
 * @property bgpSettings Virtual network gateway's BGP speaker settings.
 * @property customRoutes The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
 * @property disableIPSecReplayProtection disableIPSecReplayProtection flag.
 * @property enableBgp Whether BGP is enabled for this virtual network gateway or not.
 * @property enableBgpRouteTranslationForNat EnableBgpRouteTranslationForNat flag.
 * @property enableDnsForwarding Whether dns forwarding is enabled or not.
 * @property enablePrivateIpAddress Whether private IP needs to be enabled on this gateway for connections or not.
 * @property extendedLocation The extended location of type local virtual network gateway.
 * @property gatewayDefaultSite The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
 * @property gatewayType The type of this virtual network gateway.
 * @property id Resource ID.
 * @property ipConfigurations IP configurations for virtual network gateway.
 * @property location Resource location.
 * @property natRules NatRules for virtual network gateway.
 * @property sku The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
 * @property tags Resource tags.
 * @property vNetExtendedLocationResourceId Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
 * @property virtualNetworkGatewayPolicyGroups The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
 * @property vpnClientConfiguration The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
 * @property vpnGatewayGeneration The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
 * @property vpnType The type of this virtual network gateway.
 */
public data class VirtualNetworkGatewayArgs(
    public val activeActive: Output<Boolean>? = null,
    public val adminState: Output<Either<String, AdminState>>? = null,
    public val allowRemoteVnetTraffic: Output<Boolean>? = null,
    public val allowVirtualWanTraffic: Output<Boolean>? = null,
    public val bgpSettings: Output<BgpSettingsArgs>? = null,
    public val customRoutes: Output<AddressSpaceArgs>? = null,
    public val disableIPSecReplayProtection: Output<Boolean>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enableBgpRouteTranslationForNat: Output<Boolean>? = null,
    public val enableDnsForwarding: Output<Boolean>? = null,
    public val enablePrivateIpAddress: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val gatewayDefaultSite: Output<SubResourceArgs>? = null,
    public val gatewayType: Output<Either<String, VirtualNetworkGatewayType>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val natRules: Output<List<VirtualNetworkGatewayNatRuleArgs>>? = null,
    public val sku: Output<VirtualNetworkGatewaySkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vNetExtendedLocationResourceId: Output<String>? = null,
    public val virtualNetworkGatewayPolicyGroups: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>? =
        null,
    public val vpnClientConfiguration: Output<VpnClientConfigurationArgs>? = null,
    public val vpnGatewayGeneration: Output<Either<String, VpnGatewayGeneration>>? = null,
    public val vpnType: Output<Either<String, VpnType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayArgs.builder()
            .activeActive(activeActive?.applyValue({ args0 -> args0 }))
            .adminState(
                adminState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .allowRemoteVnetTraffic(allowRemoteVnetTraffic?.applyValue({ args0 -> args0 }))
            .allowVirtualWanTraffic(allowVirtualWanTraffic?.applyValue({ args0 -> args0 }))
            .bgpSettings(bgpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customRoutes(customRoutes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableIPSecReplayProtection(disableIPSecReplayProtection?.applyValue({ args0 -> args0 }))
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enableBgpRouteTranslationForNat(enableBgpRouteTranslationForNat?.applyValue({ args0 -> args0 }))
            .enableDnsForwarding(enableDnsForwarding?.applyValue({ args0 -> args0 }))
            .enablePrivateIpAddress(enablePrivateIpAddress?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .gatewayDefaultSite(
                gatewayDefaultSite?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .gatewayType(
                gatewayType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .natRules(
                natRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vNetExtendedLocationResourceId(vNetExtendedLocationResourceId?.applyValue({ args0 -> args0 }))
            .virtualNetworkGatewayPolicyGroups(
                virtualNetworkGatewayPolicyGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientConfiguration(
                vpnClientConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnGatewayGeneration(
                vpnGatewayGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .vpnType(
                vpnType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewayArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayArgsBuilder internal constructor() {
    private var activeActive: Output<Boolean>? = null

    private var adminState: Output<Either<String, AdminState>>? = null

    private var allowRemoteVnetTraffic: Output<Boolean>? = null

    private var allowVirtualWanTraffic: Output<Boolean>? = null

    private var bgpSettings: Output<BgpSettingsArgs>? = null

    private var customRoutes: Output<AddressSpaceArgs>? = null

    private var disableIPSecReplayProtection: Output<Boolean>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enableBgpRouteTranslationForNat: Output<Boolean>? = null

    private var enableDnsForwarding: Output<Boolean>? = null

    private var enablePrivateIpAddress: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var gatewayDefaultSite: Output<SubResourceArgs>? = null

    private var gatewayType: Output<Either<String, VirtualNetworkGatewayType>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var natRules: Output<List<VirtualNetworkGatewayNatRuleArgs>>? = null

    private var sku: Output<VirtualNetworkGatewaySkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vNetExtendedLocationResourceId: Output<String>? = null

    private var virtualNetworkGatewayPolicyGroups: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>? =
        null

    private var vpnClientConfiguration: Output<VpnClientConfigurationArgs>? = null

    private var vpnGatewayGeneration: Output<Either<String, VpnGatewayGeneration>>? = null

    private var vpnType: Output<Either<String, VpnType>>? = null

    /**
     * @param value ActiveActive flag.
     */
    @JvmName("opwqsgdllnutvpyn")
    public suspend fun activeActive(`value`: Output<Boolean>) {
        this.activeActive = value
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("lhjeoxyepvyymxht")
    public suspend fun adminState(`value`: Output<Either<String, AdminState>>) {
        this.adminState = value
    }

    /**
     * @param value Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
     */
    @JvmName("lbqknywkcblfdeda")
    public suspend fun allowRemoteVnetTraffic(`value`: Output<Boolean>) {
        this.allowRemoteVnetTraffic = value
    }

    /**
     * @param value Configures this gateway to accept traffic from remote Virtual WAN networks.
     */
    @JvmName("sosogrctuxtapxod")
    public suspend fun allowVirtualWanTraffic(`value`: Output<Boolean>) {
        this.allowVirtualWanTraffic = value
    }

    /**
     * @param value Virtual network gateway's BGP speaker settings.
     */
    @JvmName("bieysfeynebcytxo")
    public suspend fun bgpSettings(`value`: Output<BgpSettingsArgs>) {
        this.bgpSettings = value
    }

    /**
     * @param value The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("xapqxjaxqrtowwyo")
    public suspend fun customRoutes(`value`: Output<AddressSpaceArgs>) {
        this.customRoutes = value
    }

    /**
     * @param value disableIPSecReplayProtection flag.
     */
    @JvmName("vgtoxfrrjbamdcpm")
    public suspend fun disableIPSecReplayProtection(`value`: Output<Boolean>) {
        this.disableIPSecReplayProtection = value
    }

    /**
     * @param value Whether BGP is enabled for this virtual network gateway or not.
     */
    @JvmName("gqxsrcqtaryrfljy")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value EnableBgpRouteTranslationForNat flag.
     */
    @JvmName("etdtjqibbeenfhse")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Output<Boolean>) {
        this.enableBgpRouteTranslationForNat = value
    }

    /**
     * @param value Whether dns forwarding is enabled or not.
     */
    @JvmName("yseixqwnijnssqbi")
    public suspend fun enableDnsForwarding(`value`: Output<Boolean>) {
        this.enableDnsForwarding = value
    }

    /**
     * @param value Whether private IP needs to be enabled on this gateway for connections or not.
     */
    @JvmName("qsawhfmligwfyutw")
    public suspend fun enablePrivateIpAddress(`value`: Output<Boolean>) {
        this.enablePrivateIpAddress = value
    }

    /**
     * @param value The extended location of type local virtual network gateway.
     */
    @JvmName("aixofjrqctaqysha")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("krocoevytgnflbbc")
    public suspend fun gatewayDefaultSite(`value`: Output<SubResourceArgs>) {
        this.gatewayDefaultSite = value
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("ujlaoymnlmimqcee")
    public suspend fun gatewayType(`value`: Output<Either<String, VirtualNetworkGatewayType>>) {
        this.gatewayType = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("numhbggglkosulyp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IP configurations for virtual network gateway.
     */
    @JvmName("ocdqxbpsxcorkrcq")
    public suspend
    fun ipConfigurations(`value`: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("isrwcqwrhhlurait")
    public suspend fun ipConfigurations(
        vararg
        values: Output<VirtualNetworkGatewayIPConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IP configurations for virtual network gateway.
     */
    @JvmName("yhehhstjcvixvqhs")
    public suspend
    fun ipConfigurations(values: List<Output<VirtualNetworkGatewayIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kvutjbieukbctpkh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value NatRules for virtual network gateway.
     */
    @JvmName("aaabippcfrgwylng")
    public suspend fun natRules(`value`: Output<List<VirtualNetworkGatewayNatRuleArgs>>) {
        this.natRules = value
    }

    @JvmName("vffqynxhxhcvbfgk")
    public suspend fun natRules(vararg values: Output<VirtualNetworkGatewayNatRuleArgs>) {
        this.natRules = Output.all(values.asList())
    }

    /**
     * @param values NatRules for virtual network gateway.
     */
    @JvmName("nbufrsldfvbpdove")
    public suspend fun natRules(values: List<Output<VirtualNetworkGatewayNatRuleArgs>>) {
        this.natRules = Output.all(values)
    }

    /**
     * @param value The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("uctrejuhtfaafgvs")
    public suspend fun sku(`value`: Output<VirtualNetworkGatewaySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yrjetqsqstylbpiv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
     */
    @JvmName("nqojkulenrbgvmrm")
    public suspend fun vNetExtendedLocationResourceId(`value`: Output<String>) {
        this.vNetExtendedLocationResourceId = value
    }

    /**
     * @param value The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("dbxftwjewodunxgx")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(`value`: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = value
    }

    @JvmName("cuuqduuhadpbwdsq")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        values: Output<VirtualNetworkGatewayPolicyGroupArgs>,
    ) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values.asList())
    }

    /**
     * @param values The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("yoilotyybhkerqdn")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(values: List<Output<VirtualNetworkGatewayPolicyGroupArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values)
    }

    /**
     * @param value The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("mdsqyntpqvruubpb")
    public suspend fun vpnClientConfiguration(`value`: Output<VpnClientConfigurationArgs>) {
        this.vpnClientConfiguration = value
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("cenffqjpbquptjem")
    public suspend fun vpnGatewayGeneration(`value`: Output<Either<String, VpnGatewayGeneration>>) {
        this.vpnGatewayGeneration = value
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("onefgeodtdkxxhao")
    public suspend fun vpnType(`value`: Output<Either<String, VpnType>>) {
        this.vpnType = value
    }

    /**
     * @param value ActiveActive flag.
     */
    @JvmName("jrpetdsfugdoexsx")
    public suspend fun activeActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeActive = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("drgmjhedebwqcsao")
    public suspend fun adminState(`value`: Either<String, AdminState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("voutiaxnmceqqbey")
    public fun adminState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("guohipdbcsmujdmk")
    public fun adminState(`value`: AdminState) {
        val toBeMapped = Either.ofRight<String, AdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
     */
    @JvmName("skgmbovaqtemsnut")
    public suspend fun allowRemoteVnetTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVnetTraffic = mapped
    }

    /**
     * @param value Configures this gateway to accept traffic from remote Virtual WAN networks.
     */
    @JvmName("jdtofrvvsbytbqht")
    public suspend fun allowVirtualWanTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVirtualWanTraffic = mapped
    }

    /**
     * @param value Virtual network gateway's BGP speaker settings.
     */
    @JvmName("ujokrpfovcbrqllq")
    public suspend fun bgpSettings(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSettings = mapped
    }

    /**
     * @param argument Virtual network gateway's BGP speaker settings.
     */
    @JvmName("xqvpvghyrrectqgq")
    public suspend fun bgpSettings(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSettings = mapped
    }

    /**
     * @param value The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("jmtmecapmdypcocr")
    public suspend fun customRoutes(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRoutes = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("npfgxbifnwvhvteh")
    public suspend fun customRoutes(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRoutes = mapped
    }

    /**
     * @param value disableIPSecReplayProtection flag.
     */
    @JvmName("itchgkgiaasmckrd")
    public suspend fun disableIPSecReplayProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableIPSecReplayProtection = mapped
    }

    /**
     * @param value Whether BGP is enabled for this virtual network gateway or not.
     */
    @JvmName("uofwmxvvmipyqpns")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value EnableBgpRouteTranslationForNat flag.
     */
    @JvmName("dvmkrybxaalsddlf")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgpRouteTranslationForNat = mapped
    }

    /**
     * @param value Whether dns forwarding is enabled or not.
     */
    @JvmName("wkdiiieltvoaifix")
    public suspend fun enableDnsForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsForwarding = mapped
    }

    /**
     * @param value Whether private IP needs to be enabled on this gateway for connections or not.
     */
    @JvmName("ltdagrbakekqtnku")
    public suspend fun enablePrivateIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateIpAddress = mapped
    }

    /**
     * @param value The extended location of type local virtual network gateway.
     */
    @JvmName("lisdbnojhmeolqni")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of type local virtual network gateway.
     */
    @JvmName("ctqonuirycislduv")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("kxppbgtqtnmqieec")
    public suspend fun gatewayDefaultSite(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayDefaultSite = mapped
    }

    /**
     * @param argument The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("acctbbhgbywqstal")
    public suspend fun gatewayDefaultSite(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gatewayDefaultSite = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("aefwyxgpxybanybb")
    public suspend fun gatewayType(`value`: Either<String, VirtualNetworkGatewayType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("qkxibxlomndxnvpg")
    public fun gatewayType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("pytkpbvfoytvxykj")
    public fun gatewayType(`value`: VirtualNetworkGatewayType) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cglyesvtxmewxpoq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IP configurations for virtual network gateway.
     */
    @JvmName("cpqjxkvakpfvrwtb")
    public suspend fun ipConfigurations(`value`: List<VirtualNetworkGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("fuojqstfjnaxynol")
    public suspend
    fun ipConfigurations(argument: List<suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("uodcvjbfqlrlnixv")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("mqgrfrqcucbleatu")
    public suspend
    fun ipConfigurations(argument: suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IP configurations for virtual network gateway.
     */
    @JvmName("tqwsbsdfcnnajldd")
    public suspend fun ipConfigurations(vararg values: VirtualNetworkGatewayIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qgbsrssqkfgwoihh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value NatRules for virtual network gateway.
     */
    @JvmName("bawjmhdkbmsjlkkd")
    public suspend fun natRules(`value`: List<VirtualNetworkGatewayNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     */
    @JvmName("tvnwaedlgwxcmslr")
    public suspend
    fun natRules(argument: List<suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     */
    @JvmName("hmojaafuhgarmqtv")
    public suspend fun natRules(
        vararg
        argument: suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     */
    @JvmName("pmsrdopftkjibrlj")
    public suspend
    fun natRules(argument: suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param values NatRules for virtual network gateway.
     */
    @JvmName("qjdbmcbsslipqpdc")
    public suspend fun natRules(vararg values: VirtualNetworkGatewayNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param value The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("agvauuxemkmcmkmc")
    public suspend fun sku(`value`: VirtualNetworkGatewaySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("gdwitaquhnpvipve")
    public suspend fun sku(argument: suspend VirtualNetworkGatewaySkuArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewaySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("memmgmyyqssvoiox")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vxxolhqojapywlhl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
     */
    @JvmName("cexycsrvbklugdwp")
    public suspend fun vNetExtendedLocationResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetExtendedLocationResourceId = mapped
    }

    /**
     * @param value The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("pjiqynyrsklfktfg")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(`value`: List<VirtualNetworkGatewayPolicyGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("uuhyirdgqoqvieiu")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: List<suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("utnixvfjqqrcxxvo")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        argument: suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("lgulciojhqccnxuc")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param values The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("csothfttajvitaui")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        values: VirtualNetworkGatewayPolicyGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param value The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("exjmveqljoudlgjk")
    public suspend fun vpnClientConfiguration(`value`: VpnClientConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientConfiguration = mapped
    }

    /**
     * @param argument The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("ujwxgawqhqkgxjsg")
    public suspend
    fun vpnClientConfiguration(argument: suspend VpnClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VpnClientConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientConfiguration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("tuaikfrpakivrvwl")
    public suspend fun vpnGatewayGeneration(`value`: Either<String, VpnGatewayGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("jvtixgfulbvrwqwa")
    public fun vpnGatewayGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnGatewayGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("khgyrtiwfjaevbss")
    public fun vpnGatewayGeneration(`value`: VpnGatewayGeneration) {
        val toBeMapped = Either.ofRight<String, VpnGatewayGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("jpbcxssjexobrotw")
    public suspend fun vpnType(`value`: Either<String, VpnType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("yehsrlqonmpubdsq")
    public fun vpnType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("mtlnpwpgioeghddo")
    public fun vpnType(`value`: VpnType) {
        val toBeMapped = Either.ofRight<String, VpnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    internal fun build(): VirtualNetworkGatewayArgs = VirtualNetworkGatewayArgs(
        activeActive = activeActive,
        adminState = adminState,
        allowRemoteVnetTraffic = allowRemoteVnetTraffic,
        allowVirtualWanTraffic = allowVirtualWanTraffic,
        bgpSettings = bgpSettings,
        customRoutes = customRoutes,
        disableIPSecReplayProtection = disableIPSecReplayProtection,
        enableBgp = enableBgp,
        enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat,
        enableDnsForwarding = enableDnsForwarding,
        enablePrivateIpAddress = enablePrivateIpAddress,
        extendedLocation = extendedLocation,
        gatewayDefaultSite = gatewayDefaultSite,
        gatewayType = gatewayType,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        natRules = natRules,
        sku = sku,
        tags = tags,
        vNetExtendedLocationResourceId = vNetExtendedLocationResourceId,
        virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups,
        vpnClientConfiguration = vpnClientConfiguration,
        vpnGatewayGeneration = vpnGatewayGeneration,
        vpnType = vpnType,
    )
}
