@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualRouterAutoScaleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The VirtualHub Router autoscale configuration.
 * @property minCapacity The minimum number of scale units for VirtualHub Router.
 */
public data class VirtualRouterAutoScaleConfigurationArgs(
    public val minCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualRouterAutoScaleConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VirtualRouterAutoScaleConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VirtualRouterAutoScaleConfigurationArgs.builder()
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualRouterAutoScaleConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualRouterAutoScaleConfigurationArgsBuilder internal constructor() {
    private var minCapacity: Output<Int>? = null

    /**
     * @param value The minimum number of scale units for VirtualHub Router.
     */
    @JvmName("kegvrbrgorptcwne")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value The minimum number of scale units for VirtualHub Router.
     */
    @JvmName("jbfbilytratuelgw")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): VirtualRouterAutoScaleConfigurationArgs =
        VirtualRouterAutoScaleConfigurationArgs(
            minCapacity = minCapacity,
        )
}
