@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupMemberArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnPolicyMemberAttributeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VpnServerConfiguration PolicyGroup member
 * @property attributeType The Vpn Policy member attribute type.
 * @property attributeValue The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
 * @property name Name of the VpnServerConfigurationPolicyGroupMember.
 */
public data class VpnServerConfigurationPolicyGroupMemberArgs(
    public val attributeType: Output<Either<String, VpnPolicyMemberAttributeType>>? = null,
    public val attributeValue: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupMemberArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupMemberArgs =
        com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupMemberArgs.builder()
            .attributeType(
                attributeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .attributeValue(attributeValue?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigurationPolicyGroupMemberArgs].
 */
@PulumiTagMarker
public class VpnServerConfigurationPolicyGroupMemberArgsBuilder internal constructor() {
    private var attributeType: Output<Either<String, VpnPolicyMemberAttributeType>>? = null

    private var attributeValue: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("qdscjkrbwipaundi")
    public suspend fun attributeType(`value`: Output<Either<String, VpnPolicyMemberAttributeType>>) {
        this.attributeType = value
    }

    /**
     * @param value The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
     */
    @JvmName("kpqjfsokslwrekiy")
    public suspend fun attributeValue(`value`: Output<String>) {
        this.attributeValue = value
    }

    /**
     * @param value Name of the VpnServerConfigurationPolicyGroupMember.
     */
    @JvmName("ktqrrduydknabafq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("tlqansfeyfrcdmvh")
    public suspend fun attributeType(`value`: Either<String, VpnPolicyMemberAttributeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("roebmmtjgnjwinyb")
    public fun attributeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnPolicyMemberAttributeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("gwjibpbxyctunibj")
    public fun attributeType(`value`: VpnPolicyMemberAttributeType) {
        val toBeMapped = Either.ofRight<String, VpnPolicyMemberAttributeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The value of Attribute used for this VpnServerConfigurationPolicyGroupMember.
     */
    @JvmName("blmsvfyysdortjou")
    public suspend fun attributeValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeValue = mapped
    }

    /**
     * @param value Name of the VpnServerConfigurationPolicyGroupMember.
     */
    @JvmName("wrvfxhpccjfamehr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VpnServerConfigurationPolicyGroupMemberArgs =
        VpnServerConfigurationPolicyGroupMemberArgs(
            attributeType = attributeType,
            attributeValue = attributeValue,
            name = name,
        )
}
