@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AAD Vpn authentication type related parameters.
 * @property aadAudience AAD Vpn authentication parameter AAD audience.
 * @property aadIssuer AAD Vpn authentication parameter AAD issuer.
 * @property aadTenant AAD Vpn authentication parameter AAD tenant.
 */
public data class AadAuthenticationParametersResponse(
    public val aadAudience: String? = null,
    public val aadIssuer: String? = null,
    public val aadTenant: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AadAuthenticationParametersResponse):
            AadAuthenticationParametersResponse = AadAuthenticationParametersResponse(
            aadAudience = javaType.aadAudience().map({ args0 -> args0 }).orElse(null),
            aadIssuer = javaType.aadIssuer().map({ args0 -> args0 }).orElse(null),
            aadTenant = javaType.aadTenant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
