@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Load Distribution Policy of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property loadDistributionAlgorithm Load Distribution Targets resource of an application gateway.
 * @property loadDistributionTargets Load Distribution Targets resource of an application gateway.
 * @property name Name of the load distribution policy that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the Load Distribution Policy resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayLoadDistributionPolicyResponse(
    public val etag: String,
    public val id: String? = null,
    public val loadDistributionAlgorithm: String? = null,
    public val loadDistributionTargets: List<ApplicationGatewayLoadDistributionTargetResponse>? =
        null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayLoadDistributionPolicyResponse):
            ApplicationGatewayLoadDistributionPolicyResponse =
            ApplicationGatewayLoadDistributionPolicyResponse(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                loadDistributionAlgorithm = javaType.loadDistributionAlgorithm().map({ args0 ->
                    args0
                }).orElse(null),
                loadDistributionTargets = javaType.loadDistributionTargets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayLoadDistributionTargetResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
