@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP configuration of an Azure Firewall.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateIPAddress The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
 * @property provisioningState The provisioning state of the Azure firewall IP configuration resource.
 * @property publicIPAddress Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
 * @property subnet Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
 * @property type Type of the resource.
 */
public data class AzureFirewallIPConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateIPAddress: String,
    public val provisioningState: String,
    public val publicIPAddress: SubResourceResponse? = null,
    public val subnet: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallIPConfigurationResponse):
            AzureFirewallIPConfigurationResponse = AzureFirewallIPConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress(),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
