@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU of an Azure Firewall.
 * @property name Name of an Azure Firewall SKU.
 * @property tier Tier of an Azure Firewall.
 */
public data class AzureFirewallSkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallSkuResponse):
            AzureFirewallSkuResponse = AzureFirewallSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
