@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP configuration of an Bastion Host.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateIPAllocationMethod Private IP allocation method.
 * @property provisioningState The provisioning state of the bastion host IP configuration resource.
 * @property publicIPAddress Reference of the PublicIP resource.
 * @property subnet Reference of the subnet resource.
 * @property type Ip configuration type.
 */
public data class BastionHostIPConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val publicIPAddress: SubResourceResponse,
    public val subnet: SubResourceResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BastionHostIPConfigurationResponse):
            BastionHostIPConfigurationResponse = BastionHostIPConfigurationResponse(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            subnet = javaType.subnet().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
