@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the HTTP configuration.
 * @property method The HTTP method to use.
 * @property path The path component of the URI. For instance, "/dir1/dir2".
 * @property port The port to connect to.
 * @property preferHTTPS Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
 * @property requestHeaders The HTTP headers to transmit with the request.
 * @property validStatusCodeRanges HTTP status codes to consider successful. For instance, "2xx,301-304,418".
 */
public data class ConnectionMonitorHttpConfigurationResponse(
    public val method: String? = null,
    public val path: String? = null,
    public val port: Int? = null,
    public val preferHTTPS: Boolean? = null,
    public val requestHeaders: List<HTTPHeaderResponse>? = null,
    public val validStatusCodeRanges: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorHttpConfigurationResponse):
            ConnectionMonitorHttpConfigurationResponse = ConnectionMonitorHttpConfigurationResponse(
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            preferHTTPS = javaType.preferHTTPS().map({ args0 -> args0 }).orElse(null),
            requestHeaders = javaType.requestHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HTTPHeaderResponse.Companion.toKotlin(args0)
                })
            }),
            validStatusCodeRanges = javaType.validStatusCodeRanges().map({ args0 -> args0 }),
        )
    }
}
