@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the settings for producing output into a log analytics workspace.
 * @property workspaceResourceId Log analytics workspace resource ID.
 */
public data class ConnectionMonitorWorkspaceSettingsResponse(
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorWorkspaceSettingsResponse):
            ConnectionMonitorWorkspaceSettingsResponse = ConnectionMonitorWorkspaceSettingsResponse(
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
